/**
 * @fileOverview TabBar逻辑
 * @author <a href="mailto:simonsliu@tencent.com">simonsliu</a>
 * @date 12-2-29 - 上午3:47
 */
(function(window) {
	var INNER_PAGE_MAP = {
		"home": "主页",
		"option": "选项",
		"download": "下载管理",
		"history": "历史记录",
		"favorite": "整理收藏夹",
		"errorpage": "错误",
		"set-wizard": "TT升级向导"
	};
	var TAB_MAX_COUNT = 50;
	var STOP_LOADING_TIME = 5000;     // 停止显示加载图标的时间间隔，从beforeload开始计算
	var FAST_CREATE_TAB_GAP = 80;     // 判断是否快速新建标签的时间间隔阀值
	var FAST_REMOVE_TAB_GAP = 80;     // 判断是否快速删除标签的时间间隔阀值
	var FAST_SELECT_TAB_GAP = 100;     // 判断是否快速切换标签的时间间隔阀值

	// 判断是否内部页面的正则表达式
	var rInnerPage = /^qqbrowser\:(home|history|option|download|favorite|errorpage|set-wizard)$/,
		// 正在拖拽的标签对象
		draggingTab,
		sortable,
		needRelayout = true,
		// 用于缓存tabBar的动画开关值，以用于一些需临时改变动画开关的操作，如新建第一个标签，删除最后一个标签
		enableAnimate,
		// 重置快速新建标签标识位的计时器
		fastCreateTabTimmer = null,
		// 快速删除标签计时器
		fastRemoveTabTimmer = null,
		// 快速选择标签计时器
		fastSelectTabTimmer = null;


	/**
	 * 处理内部页面
	 * @param {Tab} tab 标签对象
	 * @param {String} url 页面url
	 */
	function dealInnerPage(tab, url) {
		var title, iconPath;
		tab.setData({
			urlIsInner: rInnerPage.test(url)
		});
		if (tab.data.urlIsInner) {
			iconPath = url.slice(10);
			title = INNER_PAGE_MAP[iconPath];

			if (title === undefined) {
				title = "错误";
			}

			tab.setData({
				title: title,
				// 错误页没有icon，临时处理使用默认icon
				icon: (iconPath === 'errorpage' ? DEFAULT_SITE_ICON
					: [ INNER_ICON_PATH, iconPath, ".ico" ].join("")) + '?_=' + Date.now()
			});
		}
	}

	function coreTypeBalloontip(coreTypeNotify) {
		// 先检查是否需要显示内核通知
		qqbrowser.extension.builtin.config.get(['showCoreSwitchTip'], function(retval) {
			var config = JSON.parse(retval)[0];
			// 配置为不需要显示内核通知
			if (config.hasOwnProperty('showCoreSwitchTip') && false === config.showCoreSwitchTip) {
				return;
			}

			// 用户切换记录和推荐名单冲突，则显示balloon
			if (coreTypeNotify.listType == LIST_TYPE.RECOMMENDED && coreTypeNotify.hasConflict && !coreTypeNotify.hasShowed) {
				var id = coreTypeNotify.coreType == 0 ? 'engine-ie-button' : 'engine-webkit-button';
				coreTypeNotificationTimer = setTimeout(function() {
					// 需要先显示该按钮，否则balloon出现左浏览器上角
					// $('#' + id).show();
					// 如果对应类型的内核按钮不可见，则不要显示气泡（因为C++实现不完备，会）
					if (!$('#' + id).is(':visible')) {
						return;
					}
					NotificationManager.create(document.getElementById(id), 'ENGINE.MISMATCHED_CORE_TYPE', {pageId: coreTypeNotify.pageId, coreType: coreTypeNotify.coreType});
				}, 500);
				coreTypeNotificationPageId = coreTypeNotify.pageId;
				coreTypeNotify.hasShowed = true;
			}
		});
	}

	/**
	 * 设置地址栏收藏图标状态
	 * @param {Tab} tab 标签对象
	 */
	function setAddressFavStatus(tab) {
		var tabData = tab.data, url = tabData.url;

		// 如果此时tab的url为空，那么将urlSpoof传递查询是不是已收藏项
		// 原因：url =''时 qqbrowser.bookmark.isBookmarked函数不会返回回调
		(url == '' && (url = 'urlSpoof'));

		qqbrowser.bookmark.isBookmarked(url, function(result) {
			var type = JSON.parse(result)[0];
			// 保存每个tab所对应的url是否被收藏的信息
			tabData.isBookmarked = type;

			if (tabData.isActive) { // 如果是当前页才设置地址栏fav-button对应的样式
				// 如果为url spoof网页，那么不显示收藏图标
				//(tabData.urlSpoof && (type = false));
				qqbrowser.layout.addressbar.setFavStatus(type);
			}

		});
	}

	/**
	 * 设置其它app相关，主要涉及与标签相关的其它模块的联动
	 * // TODO 采用广播机制实现app间的联动
	 * @param {Tab} tab 标签对象
	 */
	function setOtherApps(tab) {
		var tabData = tab.data, pageId = tabData.pageId;

		// 因各模块相关代码相对独立，故在各模块处定义该处需要的变量
		// [titleBar]
		// 经典大众皮肤更新标题栏标题
		Skin.app.TitleBar.instance.setData({
			title: tabData.title
		});

		// [findBar]
		// 设置findbar的状态
		var findbar = qqbrowser.layout.findbar;
		if (tabData.findInfo) {
			findbar.show(tabData.findInfo.isShow);
			findbar.setInputContent(tabData.findInfo.currentKeyWord);
			if (tabData.findInfo.count !== undefined) {
				findbar.showPlaceholder(false);
				findbar.showFindCount(true);
				findbar.setCurrentCount(tabData.findInfo.index);
				findbar.setTotalCount(tabData.findInfo.count);
				// Modified by littleli
				// 切换tab时恢复其findbar的内容以及页面查找状态
				findbar.setInputContent(tabData.findInfo.content);
				qqbrowser.js.logic.findbarManager.lastKeyWord = tabData.findInfo.content;
				for (var i = 0; i < tabData.index; ++i) {
					qqbrowser.tabs.findText(tabData.findInfo.content, true, false,
						true);
				}
			} else {
				findbar.showFindCount(false);
				if (findbar.getInputContent() === "") {
					findbar.showPlaceholder(true);
				}
			}
		} else {
			findbar.show(false);
		}

		// [navigationToolBar]
		// 设置刷新和停止加载按钮的显示与隐藏
		if (tabData.isFresh === 1) {
			qqbrowser.layout.stopLoadButton.show(false);
			qqbrowser.layout.refreshButton.show(true);
		} else {
			qqbrowser.layout.stopLoadButton.show(true);
			qqbrowser.layout.refreshButton.show(false);
		}

		// 设置page前进、后退状态
		qqbrowser.js.logic.viewManager.setBackAndForwardButtonStatus(pageId);

		// [addressBar]

		// 设置地址栏url
		// 错误页的url为原页面url，但其urlIsInner属性是true，故此仍需根据具体url判断，simonsliu
		var url = rInnerPage.test(tabData.url) ? '' : tabData.url,
			addressInfo = {
				"url": url,
				"select_start": url.length,
				"select_end": url.length
			};
		qqbrowser.layout.addressbar.setAddress(addressInfo);

		// 设置地址栏收藏图标状态
		setAddressFavStatus(tab);

		// 设置引擎按钮相关
		qqbrowser.layout.addressbar.setEngine(tabData.engine);
		qqbrowser.layout.addressbar.setEngineVisable(true); // show button

		// [caibeiInfobar]
		if (tabData.caibei) { // 如果已经显示过，属于切换逻辑
			var caibeiInfobar = qqbrowser.layout.caibeiInfobar;
			if (tabData.caibeiType === 1) {
				caibeiInfobar.caibeiButton.show(true);
				caibeiInfobar.caibeiBindButton.show(false);

				var finalText = [tabData.caibeiName, caibeiInfobar.firstText, caibeiInfobar.thirdText,
					tabData.caibeiDiscount, caibeiInfobar.lastText].join("");
				finalText = finalText + '<div id="caibeiRef">详情</div>';
				caibeiInfobar.setHtml(finalText);
				var caibeiRef = document.getElementById("caibeiRef");
				if (caibeiRef) {
					caibeiRef.onclick = function(event) {

						browser.tabs.create("http://cb.qq.com", 0);

						event.stopPropagation();
					};
				}
			} else if (tabData.caibeiType === 2) {
				caibeiInfobar.caibeiButton.show(false);
				caibeiInfobar.caibeiBindButton.show(true);

				var finalText = [tabData.caibeiName, caibeiInfobar.firstText, caibeiInfobar.secondText,
					caibeiInfobar.thirdText, tabData.caibeiDiscount, caibeiInfobar.lastText].join("");
				finalText = finalText + '<div id="caibeiRef">详情</div>';
				caibeiInfobar.setHtml(finalText);
				var caibeiRef = document.getElementById("caibeiRef");
				if (caibeiRef) {
					caibeiRef.onclick = function(event) {

						browser.tabs.create("http://cb.qq.com", 0);

						event.stopPropagation();
					};
				}

				if (caibeiInfobar.finishBind) {
					caibeiInfobar.setText("成功开启彩贝特权！您可以在浏览器选项 - 高级设置中管理彩贝业务。 ");

					caibeiInfobar.caibeiBindButton.show(false);
					caibeiInfobar.cancelButton.show(false);
				}
			}
			qqbrowser.layout.caibeiInfobar.show(true);
			qqbrowser.layout.caibeiInfobar.currentPageId = pageId;
		} else { // 如果还未显示过，那么进入
			qqbrowser.layout.caibeiInfobar.show(false);
			qqbrowser.layout.caibeiInfobar.currentPageId = -1;
		}

		// [statusBar]
		// 刷新page状态
		qqbrowser.js.logic.viewManager.showPageStatus(pageId);

		// [infoBar]
		qqbrowser.js.logic.infobarManager.showLogic(pageId);

		// 将和每个page有关的tip关闭
		NotificationManager.destroyByGroup('ENGINE');
		NotificationManager.destroyByGroup('STATUSBAR');
	}

	/**
	 * 锁定状态时设置其它app，主要用于快速切换标签栏
	 * @param {Tab} tab
	 */
	function setOtherAppsWhenLock(tab) {
		//快速切换tab(ctrl+tab)操作时，将地址和内容和图标都暂时锁住还原
		var findbar = qqbrowser.layout.findbar, tabData = tab.data, tabCount = tab.tabBar.length,
			pageId = tabData.pageId;
		// 保存切换前Tab的状态
		/*if (activeTab) {
		 if (activeTab !== tab) {
		 //            browser.log("cris+is not activeTab");
		 var beforePageId = activeTab.pageId;
		 // 保存每个页面的查找记录和状态
		 if (tabInfo[beforePageId].findInfo) {
		 tabInfo[beforePageId].findInfo.currentKeyWord = findbar.getInputContent();
		 }
		 }
		 }*/
		//暂时将其它可变的图标都恢复到初始态
		qqbrowser.layout.refreshButton.show(true);
		findbar.show(false);

		Skin.app.TitleBar.instance.setData({
			title: ''
		});

		/*tab.setActive();
		 if ( tabCount === 1 && tabData.url === DEFAULT_SITE_URL ) {
		 tab.showCloseButton( false );
		 }*/
		/*将和每个page有关的tip关闭*/
		NotificationManager.destroyByGroup('ENGINE');
		NotificationManager.destroyByGroup('STATUSBAR');
	}

	/**
	 * 更新拖拽/双击最大化区域，在默认皮肤(classic)下标签栏的双击事件有别于其它皮肤
	 */
	function updateDragArea() {
		// 因代码执行时序问题，该文件执行时，qqborwser.js尚未初始化。
		if (!qqbrowser.js) {
			return;
		}

		var themeKey = localStorage['skinTheme'];
		if (!themeKey) {
			qqbrowser.extension.builtin.config.get(["skinTheme"], function(retval) {
				var config = JSON.parse(retval)[0],
					themeKey = config["skinTheme"];

				localStorage.setItem('skinTheme', themeKey);
				updateDragArea();
			});
		} else {
			// 重新绑定classic风格的双击最大化区域，该皮肤的标签栏区域空白处双击为新建标签页
			// 新建标签页的功能绑定在标签栏模块luanch.js中 ———— simonsliu
			if (R_THEME_GROUP_CLASSIC.test(themeKey) === true) {
				qqbrowser.js.logic.eventManager.bindDragArea(["main-headbar", "cube-app-titlebar"]);
			} else {
				qqbrowser.js.logic.eventManager.bindDragArea(["main-headbar", "cube-app-tabbar", "cube-app-titlebar"]);
			}
		}
	}

	/**
	 * 设置标签栏排序
	 * @param {Skin.app.TabBar} tabBar 标签栏对象
	 */
	function setSortable(tabBar) {
		return Cube.create('Cube.capability.Sortable', {
			items: '.tab',
			excludes: '.no-drag',
			cancel: '.close-button',
			axis: 'x',
			containment: '#cube-app-tabbar',
			onStart: function(item) {
				draggingTab = tabBar[this.items.indexOf(item[0])];
			},
			onStop: function(item) {
				var itemIndex = this.items.indexOf(item[0]);
				if (draggingTab && itemIndex !== tabBar.indexOf(draggingTab)) {
					qqbrowser.tabs.drag(draggingTab.data.pageId, itemIndex);
					tabBar.resort(draggingTab, itemIndex);
				}
			}
		});
	}

	/**
	 * 弹出标签右键菜单
	 * @param {Object} data 标签数据
	 */
	function handleTabContextMenu(event, tabCloseManner, data) {
		var menuManager = qqbrowser.js.logic.menuManager;
		switch(Number(tabCloseManner)) {
			// 双击左键关闭标签，此时单击右键为打开标签右键菜单
			case 0:
				menuManager.showMenu("tabMenu", {
					tabId: data.pageId,
					pageId: data.pageId,
					triggerOnTab: 1,
					location: {
						leftBottomX: event.pageX,
						leftBottomY: event.pageY,
						rightTopY: event.pageY,
						rightTopX: event.pageX
					}
				});
			break;
			// 单击右键关闭标签
			case 1:
				qqbrowser.tabs.remove(data.pageId);
			break;
			default:
			break;
		}
	}

	var tabBar = Skin.app.TabBar.instance = Skin.app.TabBar.$create({
		element: Cube('#cube-app-tabbar'),
		onInitialize: function() {
			sortable = setSortable(this);
		},
		onAddTabButtonClick: function() {
			if (this.length === TAB_MAX_COUNT) {
				return;
			}
			// 新建页面，系统自动处理该新建什么页面
			qqbrowser.tabs.newTab(qqbrowser.window.currentId());
			browser.extension.builtin.statistics.increase(STATIS_USE_TAB_OPENED_NOLINK);
		},
		onAddTabButtonMouseOver: function() {
			// TODO qqbrowser.js.logic.tipManager重构后需修改 simonsliu
			qqbrowser.js.logic.tipManager.showTip('add-tab-button', 'mouseover');
		},
		onBeforeRemoveTab: function(tab) {
			if (this.length === 1) {
				if (tab.data.url === DEFAULT_SITE_URL) {
					return;
				}
				if (enableAnimate) {
					this.enableAnimate = false;
				}
			}
		},
		onRemoveTab: function(tab) {
			if (this.length === 0) {
				qqbrowser.tabs.create(DEFAULT_SITE_URL, 0, 0, false);
				if (enableAnimate) {
					this.enableAnimate = true;
				}
			}


			if (this.length === 1) {
				// 仅剩一个标签
				// 处理关闭按钮的隐藏与显示
				if (this[0].data.urlIsInner) {
					this[0].hideComponent('closeButton');
					this[0].closeButton.neverShow = true;
				}
			}

			if (tab.data.caibei) {
				qqbrowser.layout.caibeiInfobar.isShow = false;
			}
			sortable.update();
		},
		onMouseWheel: function(event) {
			// 鼠标中键点击关闭标签最后一个标签时可能触发滚轮事件，而此时是没有标签的。
			if (this.length === 0) {
				return;
			}
			var tab = this.activeTab, index = this.indexOf(tab),
				length = this.length;
			// 向下滚轮，向右移动tab
			if (event.wheelDelta > 0) {
				this[(length + index - 1) % length].activate();
			} else {
				this[(index + 1) % length].activate();
			}
			qqbrowser.tabs.select(this.activeTab.data.pageId);
			setOtherApps(this.activeTab);
		},
		onDblClick: function(event) {
			// 必须点击在标签栏空白处，即标签栏元素上，点击在其子元素上不生效
			if (event.target !== this.element[0]) {
				return;
			}
			// 当且仅当默认皮肤(即经典皮肤)下点击标签栏空白处才有新建操作
			if (document.documentElement.className.indexOf('theme-group-classic') > -1) {
				if (this.length === TAB_MAX_COUNT) {
					return;
				}

				qqbrowser.tabs.create(DEFAULT_SITE_URL, 0, 0, false);
			}
		},
		onCreateTab: function() {
			sortable.update();
		},
		onContextMenu: function(event) {
			// 防止与标签上的右键点击冲突
			if (event.target !== this.element[0]) {
				return;
			}
			var menuManager = qqbrowser.js.logic.menuManager, pageId = this.activeTab.data.pageId;
			if (document.documentElement.className.indexOf('theme-group-simple') > -1) {
				menuManager.showMenu("titleBarMenu", {
					pageId: pageId,
					location: {
						leftBottomX: event.pageX,
						leftBottomY: event.pageY,
						rightTopY: event.pageY,
						rightTopX: event.pageX
					}
				});
			} else {
				menuManager.showMenu("tabMenu", {
					tabId: pageId,
					pageId: pageId,
					triggerOnTab: 0,
					location: {
						leftBottomX: event.pageX,
						leftBottomY: event.pageY,
						rightTopY: event.pageY,
						rightTopX: event.pageX
					}
				});
			}
		},
		onTabCloseButtonClick: function(event, tab) {
			qqbrowser.tabs.remove(tab.data.pageId);
		},
		onTabCloseButtonMouseOver: function(event, tab) {
			qqbrowser.js.logic.tipManager.showCloseTabTip(tab);
		},
		onTabMouseOver: function(event, tab) {
			qqbrowser.js.logic.tipManager.showTabTip(tab, event);
		},
		onTabMouseDown: function(event, tab) {
			var tabData = tab.data;
			if (event.which === 1) {
				if (tabData.isActive) {
					return;
				}
				tab.activate();
				qqbrowser.tabs.select(tabData.pageId);
				setOtherApps(tab);
			} else if (event.which === 2) {
				qqbrowser.tabs.remove(tabData.pageId);
			}
		},
		onTabMouseUp: function(event, tab) {
			if (Skin.app.TabBar.isDraging) {
				$(this.activeTab.element[0]).mouseup();
				Skin.app.TabBar.isDraging = false;
			}
			qqbrowser.js.logic.viewManager.setFocus(tab.data.url);
		},
		onTabContextMenu: function(event, tab) {
			qqbrowser.extension.builtin.config.get(['tabCloseManner'], function(result) {
				var tabCloseManner;
				result = Cube.Object.parseJson(result);
				if (!result) {
					return;
				}
				result = result[0];
				tabCloseManner = result.tabCloseManner || 0;
				handleTabContextMenu(event, tabCloseManner, tab.data);
			});
		},
		onTabDblClick: function(event, tab) {
			qqbrowser.extension.builtin.config.get(['tabCloseManner'], function(result) {
				var tabCloseManner;
				result = Cube.Object.parseJson(result);
				if (!result) {
					return;
				}
				result = result[0];
				tabCloseManner = result.tabCloseManner || 0;
				if(tabCloseManner === 0) {
					qqbrowser.tabs.remove(tab.data.pageId);
				}
			});

		},
		onTabDeactivate: function(tab) {
			if (tab.closeButton.shouldHidden) {
				tab.hideComponent('closeButton');
			}
		}
	});

	// 初始化enableAnimate缓存
	enableAnimate = tabBar.enableAnimate;

	// 更新拖拽/双击最大化区域
	updateDragArea();

	// 合并方法到Skin.app.TabBar以替换全局的qqbrowser.js.logic.tabManager
	Cube.extend(Skin.app.TabBar, {
		setAddressFavStatus: setAddressFavStatus,
		DEFAULT_SITE_URL: DEFAULT_SITE_URL,
		BLANK_PAGE_URL: BLANK_PAGE_URL
	});

	window.addEventListener('resize', function() {
		if (enableAnimate) {
			tabBar.enableAnimate = false;
		}
		tabBar.updateWidth(tabBar.getMaxTotalWidth());
		tabBar.releaseAddButton();
		tabBar.relayout(tabBar);
		if (enableAnimate) {
			tabBar.enableAnimate = enableAnimate;
		}
	});

	// 浏览器后台事件绑定
	// @author simonsliu
	// @date 2012-03-07

	/**
	 * 响应页面新建完成事件
	 * @param {Number} engine 内核类型代号 0-ie内核,1-webkit
	 */
	qqbrowser.tabs.onNewPageCreated.addListener(function(url, title, engine, pageId, index, isActive, parentId) {
		// 超过最大标签数时直接删除跳出，临时方案，需后台同步调整最大标签数
		if (tabBar.length === TAB_MAX_COUNT) {
			qqbrowser.tabs.remove(pageId);
			return;
		}

		title = Cube.String.htmlEncode(title);

		var icon = '', urlIsInner = rInnerPage.test(url),
			iconPath, enableAnimate = tabBar.enableAnimate, tab;

		if (urlIsInner) {
			iconPath = url.slice(10);
			title = INNER_PAGE_MAP[iconPath];

			if (title === undefined) {
				title = "错误";
			}
			icon = [ INNER_ICON_PATH, iconPath, ".ico" ].join("") + '?_=' + Date.now();
		}

		url = urlIsInner ? '' : url;

		// 仅有首个tab有可能显示默认浏览器infobar
		if (qqbrowser.layout.defaultBrowserInfobar) {
			if (pageId !== 1) {
				qqbrowser.layout.defaultBrowserInfobar.show(false);
			}
		}
		if (( tabBar.length === 0 || fastCreateTabTimmer !== null ) && enableAnimate) {
			tabBar.enableAnimate = false;
			if (fastCreateTabTimmer !== null) {
				window.clearTimeout(fastCreateTabTimmer);
			}
		}
		tab = tabBar.createTab({
			addressInfo: {
				"url": url,
				"select_start": url.length,
				"select_end": url.length
			},
			url: url,
			title: title,
			pageId: pageId,
			index: index,
			icon: icon,
			urlIsInner: urlIsInner,
			parentId: parentId,
			urlSpoof: true,
			isActive: isActive
		});

		tabBar.enableAnimate = enableAnimate;

		if (isActive) {
			qqbrowser.tabs.select(pageId);
			qqbrowser.js.logic.viewManager.setFocus(url);
			setOtherApps(tab);
		}


		fastCreateTabTimmer = window.setTimeout(function() {
			fastCreateTabTimmer = null;
		}, FAST_CREATE_TAB_GAP);

		return;
	});

	/**
	 * 响应地址栏变更事件
	 */
	qqbrowser.tabs.onAddressChanged.addListener(function(pageId, url) {
		var tab = tabBar.getTabByData('pageId', pageId), tabData = tab.data,
			needSetAddress = true,
			// 彩贝相关的域名截取
			tempDomain = url.substring(url.indexOf(".") + 1),
			domain = url, addressInfo;

		tab.setData({
			url: url,
			urlSpoof: false
		});

		if (rInnerPage.test(url)) {
			if (qqbrowser.layout.addressbar.getAddress().url !== url) {
				needSetAddress = false;
			}
			url = "";
		}

		addressInfo = {
			"url": url,
			"select_start": url.length,
			"select_end": url.length
		};

		tab.setData({
			addressInfo: addressInfo
		});

		if (tabData.isActive) {
			if (needSetAddress) {
				qqbrowser.layout.addressbar.setAddress(addressInfo);
				qqbrowser.js.logic.viewManager.setFocus(url);

			}
			if (qqbrowser.js.logic.isLogin && !qqbrowser.js.logic.caibeiBindConfirm) {
				qqbrowser.js.logic.infobarManager.caibeiInfobarLogic(domain, pageId);
			}

		}

	});

	/**
	 * 页面加载完成
	 * @param {Number} 页面ID
	 */
	qqbrowser.tabs.onPageLoadEnd.addListener(function(pageId) {
		var tab = tabBar.getTabByData('pageId', pageId), tabData = tab.data,
			addressInfo;
		// Url spoof安全漏洞解决
		// Url spoof安全漏洞在onNewpageCreate事件,onStatusTextChange事件的loadbefore及loading状态时会发送一个错误的url
		// 但不会收到正确的onaddresschange事件,所以每个tab会在onaddresschange事件中再次确认url的正确性，如果不正确的话
		// 进行下面的安全漏洞显示修复
		if (tabData.urlSpoof) {
			addressInfo = {
				"url": '',
				"select_start": 0,
				"select_end": 0
			};
			// 在这里更新恶意url spoof tab的url值
			tab.setData({
				url: '',
				title: '无标题'
			});
			if (tabData.isActive) {
				qqbrowser.layout.addressbar.setAddress(addressInfo);
				setAddressFavStatus(tab);
				// 类似于chrome的处理方式，出现这种情况时设置tab的title为‘无标题’，icon为默认icon
				tab.setData({
					title: '无标题',
					icon: DEFAULT_SITE_ICON + '?_=' + Date.now()
				});

				// TODO 需要将标题栏相关操作打包，simonsliu
				// 标题栏内容更新
				Skin.app.TitleBar.instance.setData({
					title: tab.data.title
				});
			}
		}

		if (tab.stopLoadingTimmer) {
			window.clearTimeout(tab.stopLoadingTimmer);
			delete tab.stopLoadingTimmer;
		}

		if (!tabData.urlIsInner) {
			if (tabData.iconCache !== undefined) {
				tab.setData({
					icon: tabData.iconCache
				});
				delete tabData.iconCache;
			} else {
				tab.setData({
					icon: DEFAULT_SITE_ICON
				});
			}
		}

		tabData.loadStatus.loadEnd = true;

		// 加载云词典 simonsliu 2011-11-10
		if (qqbrowser.layout.cloudDictButton.isCloudDictOpen === true) {
			qqbrowser.layout.cloudDictButton.open(pageId);
		} else {
			qqbrowser.layout.cloudDictButton.close(pageId);
		}
		// 加载云词典 END

		return [true];
	});

	/**
	 * 关闭页面 快捷键 Ctrl + W直接删除page 功能和显式调用qqbrowser.tabs.remove(pageId)一致
	 */
	qqbrowser.tabs.onPageClosed.addListener(function(pageId, selectId, selectIndex, windowId) {
		var tab = tabBar.getTabByData('pageId', pageId), tabData = tab.data;

		if (tabData.caibei) { // 解决关闭时清空caibeiinfobar显示的标识位
			qqbrowser.layout.caibeiInfobar.isShow = false;
		}

		if (!tab) {
			return;
		}

		if (fastRemoveTabTimmer !== null) {
			if (enableAnimate) {
				tabBar.enableAnimate = false;
			}
			window.clearTimeout(fastRemoveTabTimmer);
			fastRemoveTabTimmer = null;
		}

		tabBar.removeTab(tab);
		tabBar.enableAnimate = enableAnimate;

		fastRemoveTabTimmer = window.setTimeout(function() {
			fastRemoveTabTimmer = null;
		}, FAST_REMOVE_TAB_GAP);
	});

	/**
	 * 关闭后选择下一个可用Tab 关闭页面 + 快捷键 Ctrl + Tab触发此事件
	 * @param {Number} pageId 选中的页面ID
	 * @param {Number} selectedIndex 选中的页面索引值
	 */
	qqbrowser.tabs.onSelectPageId.addListener(function(pageId, selectedIndex) {
		var tab = tabBar.getTabByData('pageId', pageId), tabData = tab.data,
			viewManager = qqbrowser.js.logic.viewManager,
			url = tabData.url, pageId = tabData.pageId;

		tab.activate();

		// 非连续切换tab时，将statusbar锁定，不更新状态信息
		if (fastSelectTabTimmer === null) {
			viewManager.setFocus(url);
			if (!tab.closeButton.neverShow) {
				tab.showComponent('closeButton');
			}
			setOtherApps(tab);
		} else {
			window.clearTimeout(fastSelectTabTimmer);
			fastSelectTabTimmer = window.setTimeout(function(tab) {
				fastSelectTabTimmer = null;
				// 快速删除时可能该tab已经删除
				if (this.activeTab !== tab || !tabBar.getTabByData('pageId', tab.data.pageId)) {
					return;
				}
				viewManager.setFocus(tab.data.url);
				if (!tab.closeButton.neverShow) {
					tab.showComponent('closeButton');
				}
				setOtherApps(tab);
			}.bind(tabBar, tab), FAST_SELECT_TAB_GAP);
		}
	});

	var coreTypeNotificationTimer = null;
	var coreTypeNotificationPageId = null;

	qqbrowser.tabs.onPageSelected.addListener(function(pageId, windowId, url) {
		var tab = tabBar.getTabByData('pageId', pageId), tabData = tab.data;
		
		// 销毁所有内核通知
		NotificationManager.destroyByGroup('ENGINE');

		// 如果是切换标签，而不是新打开标签
		if (pageId != coreTypeNotificationPageId) {
			clearTimeout(coreTypeNotificationTimer);
		}
		
		// 首先隐藏旧标签的balloons
		// clearTimeout(coreTypeNotificationTimer);
		
		// 然后根据内核切换数据判断是否要展示 ENGINE.MISMATCHED_CORE_TYPE 通知
		if (tabData.coreTypeNotify) {
			coreTypeBalloontip(tabData.coreTypeNotify);
		}
	});

	/**
	 * 状态栏文本改变事件
	 * @param {Number} pageId 当前页面ID
	 * @param {Number} nStatusType 状态类型
	 *         0 -> beforeload
	 *         1 -> loading
	 *         2 -> error
	 *         3 -> loadend(successs)
	 *         4 -> mouse over page content 鼠标滑到页面内容
	 *         5 -> 出现脚本错误的警告
	 * @param {String} url 状态改变对应的url, 0未必有，1有，2未必有，3未必有，4对应hover到的url，其它状态时为当前页面的url
	 */
	qqbrowser.tabs.onStatusTextChange.addListener(function(pageId, nStatusType, url) {
		var addressbar = qqbrowser.layout.addressbar, findbar = qqbrowser.layout.findbar,
			tab = tabBar.getTabByData('pageId', pageId), tabData = tab.data,
			addressInfo;

		url = Cube.String.htmlDecode(url);

		// 根据url判断page是否为内部页面
		// 若为内部页面则马上设置其和Tab相关的信息
		switch (nStatusType) {
			case 0:
				dealInnerPage(tab, url);
				if (tabData.urlIsInner === true) {
					url = '';
				} else {
					tab.setLoading('before-loading');
				}

				addressInfo = {
					"url": url,
					"select_start": url.length,
					"select_end": url.length
				};

				// 控制首个tab显示关闭逻辑
				// 当只剩一个标签时，当且仅当页面是浏览器主页时才隐藏关闭按钮 added by simons 2011-11-01
				if (tabBar.length === 1) {
					if (tabData.urlIsInner === true) {
						tab.hideComponent('closeButton');
						tab.closeButton.neverShow = true;
					} else {
						tab.closeButton.neverShow = false;
						if (!tab.closeButton.shouldHidden) {
							tab.showComponent('closeButton');
						}
					}
				} else {
					tabBar[0].closeButton.neverShow = false;
					if (!tabBar[0].closeButton.shouldHidden) {
						tabBar[0].showComponent('closeButton');
					}
				}

				// 清空页面错误的标志位
				tab.setData({
					error: false,
					scripterror: false
				});

				// 设置状态栏
				qqbrowser.js.logic.viewManager.setPageStatus(pageId, "loadbefore");

				/**
				 * 页面重新导航后，调整findbar的状态及显示
				 * 如果导航地址相同（切换内核、输入相同url）那么不隐藏findbar
				 * 如果导航地址不同，隐藏findbar并清空其内容
				 */

				if (tabData.url !== url) {
					if (tabData.findInfo !== undefined) {
						tabData.findInfo.isShow = false;
						tabData.findInfo.currentKeyWord = "";
						tabData.findInfo.index = null;
						tabData.findInfo.count = null;
						findbar.showFindCount(false);
						browser.tabs.stopFinding(true);
						findbar.show(false);
					}
					
					// Modified by littleli
					// 如果显示密码保存页面的url发生改变，那么将其关闭
					var extId = "{75A78384-8765-4852-ABB7-8D5FA8BF48E2}";
					var cmd = {};
					var savePWTab;
					cmd.command = "noSavePwd";
					cmd.pageId = qqbrowser.layout.savePWinfobar.currentPageId;
					qqbrowser.extension.sendRequest(extId, cmd, function() {});
					savePWTab = tabBar.getTabByData('pageId', cmd.pageId);
					if (savePWTab) {
						delete savePWTab.data.savePW
					}
					qqbrowser.layout.savePWinfobar.show(false);

				}

				if ("undefined" !== typeof(url)) {
					if (tabData.url !== url) {
						tabData.url = url;
						if (tabData.crashCount) {
							tabData.crashCount = undefined;
						}
					}
					// 设置地址栏的内容
					if (tabData.isActive) {
						addressbar.setAddress(addressInfo);
					}
				}
				break;
			case 1:
				// 内部页面处理
				dealInnerPage(tab, url);
				if (!tabData.urlIsInner) {
					tab.setLoading('loading');
					tab.stopLoadingTimmer = window.setTimeout(function() {
						// clearTimeout(tab.stopLoadingTimmer) 和 delete tab.stopLoadingTimmer之后依然会执行到该函数
						if (!tab.stopLoadingTimmer) {
							return;
						}
						delete tab.stopLoadingTimmer;
						tab.setData({
							icon: tabData.iconCache || DEFAULT_SITE_ICON + '?_=' + Date.now()
						});
					}, STOP_LOADING_TIME);
				}

				// 如果此时tab的url为空，那么将urlSpoof传递查询是不是已收藏项
				// 原因：url =''时 qqbrowser.bookmark.isBookmarked函数不会返回回调
				if (url === '') {
					url = 'urlSpoof';
				}

				qqbrowser.bookmark.isBookmarked(url, function(result) {
					var type = JSON.parse(result)[0];
					// 保存每个tab所对应的url是否被收藏的信息
					tabData.isBookmarked = type;

					if (tabData.isActive) { // 如果是当前页才设置地址栏fav-button对应的样式
						// 如果为url spoof网页，那么不显示收藏图标
						//(tabData.urlSpoof && (type = false));
						qqbrowser.layout.addressbar.setFavStatus(type);
					}
				});

				tab.setData({
					url: tabData.urlIsInner ? '' : url
				});

				addressInfo = {
					"url": url,
					"select_start": url.length,
					"select_end": url.length
				};

				// 正在加载时隐藏“刷新”按钮并显示“停止加载”按钮
				if (!tabData.urlIsInner) {
					tab.setData({
						isFresh: 0
					});
					if (tabData.isActive) {
						qqbrowser.layout.stopLoadButton.show(true);
						qqbrowser.layout.refreshButton.show(false);
					}
				}

				// 此时设定页面“未加载完成”状态
				tab.setData({
					loadStatus: {
						loadEnd: false
					}
				});

				// 设定状态栏对应的状态显示———“加载中”
				qqbrowser.js.logic.viewManager.setPageStatus(pageId, "loading"); // 设置状态栏
				if (undefined !== url && "" !== url) { // 代码保护

					//如果页面前后url不同，代表进行了一次新导航
					//新导航时需要清掉以前页面的崩溃次数
					if (tabData.url !== url) {
						// Modified by littleli，解决一个安全漏洞，防止url刷新
						if (tabData.crashCount) {
							tab.setData({
								crashCount: undefined
							});
						}
					}
				}
				break;
			case 2:
				// 加载失败时隐藏“停止加载”按钮并显示“刷新按钮”
				if (!tabData.urlIsInner) {
					tab.setData({
						isFresh: 1
					});

					if (tabData.isActive) {
						qqbrowser.layout.stopLoadButton.show(false);
						qqbrowser.layout.refreshButton.show(true);
					}
				}
				tab.setData({
					error: true
				});
				// 设置状态栏
				qqbrowser.js.logic.viewManager.setPageStatus(pageId, "loaderror");
				break;
			case 3:
				// 加载成功时隐藏“停止加载”按钮并显示“刷新”按钮
				if (!tabData.urlIsInner) {
					tab.setData({
						isFresh: 1
					});
					if (tabData.isActive) {
						qqbrowser.layout.stopLoadButton.show(false);
						qqbrowser.layout.refreshButton.show(true);
					}
				}
				// 设置状态栏
				qqbrowser.js.logic.viewManager.setPageStatus(pageId, "loadend");
				break;
			case 4:
				if ("undefined" === typeof(url) || "" === url) {
					qqbrowser.js.logic.viewManager.showPageStatus(pageId, "loadend");
				} else {
					qqbrowser.js.logic.viewManager.setStatusUrl(url);
				}
				break;
			case 5:
				tab.setData({
					scripterror: true
				});
				// 设置状态栏
				qqbrowser.js.logic.viewManager.setPageStatus(pageId, "scripterror");
				break;
			default:
				break;
		}
		return [ true ];
	});

	// 页面状态改变tab前进后退状态
	// @param go & forward: boolean
	// @param tabState: 1崩溃 2假死
	/**
	 * @param {Number} pageId
	 * @param {Boolean} back 回退是否可用
	 * @param {Boolean} forward 前进是否可用
	 * @param {Number} tabState 正常/崩溃/假死状态，0 -> 正常，1 -> 崩溃，2 -> 假死
	 */
	qqbrowser.tabs.onTabStatusChanged.addListener(function(pageId, back, forward, tabState) {
		var tab = tabBar.getTabByData('pageId', pageId), tabData = tab.data;

		var pageInfobar = qqbrowser.layout.pageInfobar;

		tabData.back = back;
		tabData.forward = forward;

		// add by littleli
		// 解决假死黄条出现后不消失的问题
		if (tabData.tabState === 2 && tabState === 0) {
			pageInfobar.show(false);
		}

		tabData.tabState = tabState;

		// 如果是当前tab，立即改变按钮状态
		if (tabData.isActive) {
			// 设置tab前进、后退的显示状态
			qqbrowser.js.logic.viewManager.setBackAndForwardButtonStatus(pageId);
			if (tabState === 1) { // 崩溃
				if (tabData.crashCount) {
					tabData.crashCount = 2;
				} else {
					tabData.crashCount = 1;
				}

				if (tabData.crashCount === 1) {
					pageInfobar.setText(pageInfobar.crashFirstTimeText);
					pageInfobar.type = 0;
					// 状态操作
					pageInfobar.removeClass("warning");
					pageInfobar.addClass("common");
					pageInfobar.setIcon("infobar-icon-warning-common.png");
					//pageInfobar.showClose(false);
					tabData.isFresh = 0;
					pageInfobar.refreshButton.show(false);
					pageInfobar.show(true);
					browser.extension.builtin.statistics.increase(1410301);

					browser.page.reload(browser.getCurrentPageId()); // 直接刷新
					setTimeout(function() {
						if (tabData.isActive) {
							pageInfobar.show(false);
						}
					}, 5000);
				} else if (tabData.crashCount === 2) {

					pageInfobar.setText(pageInfobar.crashText);
					pageInfobar.type = 1;

					// 状态操作
					pageInfobar.removeClass("common");
					pageInfobar.addClass("warning");
					pageInfobar.setIcon("infobar-icon-warning.png");

					//pageInfobar.showClose(false);
					tabData.isFresh = 1;
					pageInfobar.refreshButton.show(true);
					pageInfobar.closeButton.show(true);
					pageInfobar.show(true);
					browser.extension.builtin.statistics.increase(1410201);
				}
			} else if (tabState === 2) { // 假死
				pageInfobar.setText(pageInfobar.zombieText);
				pageInfobar.type = 2;

				// 状态操作
				pageInfobar.removeClass("common");
				pageInfobar.addClass("warning");
				pageInfobar.setIcon("infobar-icon-warning.png");

				pageInfobar.showClose(true);
				pageInfobar.closeButton.show(true);
				tabData.isFresh = 1;
				pageInfobar.refreshButton.show(true);
				pageInfobar.show(true);
				browser.extension.builtin.statistics.increase(1410101);
			} else {
				if (tabData.crashCount === 0) {
					pageInfobar.show(false);
				}
			}
		}
	});


	/**
	 * 恢复崩溃页面的infobar提示
	 * @param go & forward: boolean
	 * @param tabState: 1崩溃 2假死
	 */
	qqbrowser.tabs.onCrashRestore.addListener(function(data) {
		if (qqbrowser.layout.recoverInfobar === undefined) {
			qqbrowser.layout.recoverInfobar = new qqbrowser.js.widgets.infobar("recoverInfobar");
			
			// 初始化设置recover infobar的部分
			var recoverInfobar = qqbrowser.layout.recoverInfobar;
			recoverInfobar.addClass("common");

			recoverInfobar.onShow(function() {
				qqbrowser.js.logic.layoutManager.resize();
			});

			recoverInfobar.onHide(function() {
				qqbrowser.js.logic.layoutManager.resize();
			});

			recoverInfobar.recoverText = "浏览器上次没有正常退出，是否需要恢复之前浏览的网页？";
			recoverInfobar.recoverButton = new qqbrowser.js.widgets.button("infobar-recoverbutton");
			recoverInfobar.cancelButton = new qqbrowser.js.widgets.button("infobar-cancelbutton");

			recoverInfobar.setIcon("question.png");

			recoverInfobar.recoverButton.setText("恢复");
			recoverInfobar.addAction(recoverInfobar.recoverButton);
			recoverInfobar.recoverButton.show(true);
			recoverInfobar.cancelButton.setText("取消");
			recoverInfobar.addAction(recoverInfobar.cancelButton);
			recoverInfobar.cancelButton.show(true);


			recoverInfobar.showClose(true);
			recoverInfobar.setText(recoverInfobar.recoverText);
			recoverInfobar.insert(document.getElementById("main-infobar"));

			recoverInfobar.show(true);
			browser.extension.builtin.statistics.increase(1410501);

			var results = JSON.parse(data);

			recoverInfobar.recoverButton.onclick(function(event) {
				// 做相应的事件处理
				for (var i = 0; i < results.length; i++) {
					// 标识为来自皮肤创建的页面
					browser.tabs.create(unescape(results[i].url), 0);
				}
				recoverInfobar.show(false);
				browser.extension.builtin.statistics.increase(STATIS_TIPBAR_RECOVERYEXCEPTION_ITEM_RECOVERY_CLICKED);
				event.stopPropagation();
			});

			recoverInfobar.cancelButton.onclick(function(event) {
				recoverInfobar.show(false);
				browser.extension.builtin.statistics.increase(STATIS_TIPBAR_RECOVERYEXCEPTION_ITEM_CANCEL_CLICKED);
				event.stopPropagation();
			});

			recoverInfobar._close.onclick(function(event) {
				recoverInfobar.show(false);
				browser.extension.builtin.statistics.increase(STATIS_TIPBAR_RECOVERYEXCEPTION_ITEM_XBTN_CLICKED);
				event.stopPropagation();
			});

		}
	});

	/**
	 * 获取到页面标题时的事件
	 * @param {Number} pageId 页面ID
	 * @param {String} title 页面标题
	 */
	qqbrowser.tabs.onTitleChanged.addListener(function(pageId, title) {
		var tab = tabBar.getTabByData('pageId', pageId), tabData = tab.data;

		title = Cube.String.htmlEncode(title);

		if (!title || title === "about:blank") {
			title = "空白页";
		}


		tab.setData({
			title: title
		});

		if (tabData.isActive) {
			// 经典大众皮肤更新标题栏标题
			Skin.app.TitleBar.instance.setData({
				title: title
			});
		}
	});

	/**
	 * 获取到页面icon时的回调事件
	 * @param {Number} pageId 页面ID
	 * @param {String} url 网页icon图片url
	 */
	qqbrowser.tabs.onWebIconReady.addListener(function(pageId, icon) {
		var tab = tabBar.getTabByData('pageId', pageId), tabData = tab.data;
		if (tabData.urlIsInner === true) {
			return;
		}

		if (tabData.loadStatus.loadEnd === true) {
			tab.setData({
				icon: icon
			});
		} else {
			tab.setData({
				iconCache: icon
			})
		}

		return [ true ];

	});

	/**
	 * 主题改变时触发的事件
	 * @param {String} strTheme 主题名称
	 */
	qqbrowser.skin.onThemeChanged.addListener(function(themeName) {
		// 更换内部页icon
		var tab, i, iconSrc, link,
			initSrc = "qqbrowser://skin/images/innerIcons";

		for (i = 0; i < tabBar.length; i++) {
			tab = tabBar[ i ];
			iconSrc = tab.data.icon;
			if (iconSrc.indexOf(initSrc) !== -1 && iconSrc.indexOf(themeName) === -1) {
				iconSrc = iconSrc.indexOf("?") === -1 ?
					iconSrc :
					iconSrc.substring(0, iconSrc.indexOf("?"));

				tab.setData({
					icon: iconSrc + "?v=" + themeName
				});
			}

		}
		// 更换内部页icon end

		link = document.getElementById("theme-style");
		link.href = "qqbrowser://skin/style.css?_=" + Date.now();

		// 换肤后调整布局及换肤面板位置
		window.setTimeout(function() {
			qqbrowser.js.logic.layoutManager.resize();
			if (enableAnimate) {
				tabBar.enableAnimate = false;
			}
			//tabBar.releaseAddButton();
			tabBar.updateWidth(tabBar.getMaxTotalWidth());
			tabBar.relayout(tabBar);
			if (enableAnimate) {
				tabBar.enableAnimate = enableAnimate;
			}

			var skinButton = qqbrowser.layout.sysmenuSkinButton._element;
			var buttonLeftBottom = qqbrowser.js.logic.viewManager.getMenuLeftBottom(skinButton);

			// 解决换肤后换肤面板跟随的问题
			var buttonLeftBottomLeft = buttonLeftBottom.left;
			var buttonLeftBottomTop = buttonLeftBottom.top;
			if (skinButton.offsetParent) {
				buttonLeftBottomLeft += skinButton.offsetParent.offsetLeft;
				buttonLeftBottomTop += skinButton.offsetParent.offsetTop;
			}

			var width = skinButton.offsetWidth;

			var x = buttonLeftBottomLeft + (width / 2);
			var y = buttonLeftBottomTop;

			qqbrowser.popup.relocate(qqbrowser.js.logic.popupManager.nLastPopupId, parseInt(x), parseInt(y));

			// 更新拖拽/双击最大化区域
			updateDragArea();
		}, 400);
	});

	/**
	 * 内核切换事件
	 * about core type change
	 * type 0: IE, 1: Webkit, 2: hide for internal page
	 */
	qqbrowser.tabs.onCoreTypeChanged.addListener(function(pageId, type) {
		var tab = tabBar.getTabByData('pageId', pageId), tabData = tab.data;

		tabData.engine = type;
		// modified by yinzhou
		// 地址栏只有一个，tab有多个，地址栏反应的是当前tab信息
		if (tabData.isActive) {
			qqbrowser.layout.addressbar.setEngine(type);
		}

		qqbrowser.js.logic.findbarManager.lastKeyWord = null;
		qqbrowser.layout.addressbar.setEngineVisable(true); // show button
	});

	// 冲突的时候，coreType的值是推荐名单的内核，listType的值是1（推荐名单）
	qqbrowser.tabs.onCoreTypeNotify.addListener(function(pageId, coreType, listType, hasConflict) {
		var tab = tabBar.getTabByData('pageId', pageId), tabData = tab.data;

		tabData.coreTypeNotify = {
			pageId: pageId,
			coreType: coreType,
			listType: listType,
			hasConflict: hasConflict,
			hasShowed: false
		};

		// 如果收到这个事件的时候，Tab已经处于激活，则判断是否要显式通知
		if (tabData.isActive) {
			// 首先隐藏旧标签的balloons
			clearTimeout(coreTypeNotificationTimer);
			NotificationManager.destroyByGroup('ENGINE');

			// 如果有内核切换数据
			coreTypeBalloontip(tabData.coreTypeNotify);
		}
	});

	qqbrowser.tabs.onBeforeMenu.addListener(function(params) {
		var menuInfo = eval('(' + params + ')');

		var location = {
			leftBottomX: menuInfo.x,
			leftBottomY: menuInfo.y,
			rightTopY: menuInfo.y,
			rightTopX: menuInfo.x
		};
		var contentParams = menuInfo;

		var menuParams = {
			location: location,
			contentParams: contentParams
		};

		qqbrowser.js.logic.menuManager.showMenu('contentMenu', menuParams);
	});

	/**
	 * 页面内查找功能查找结果显示回调
	 */
	qqbrowser.tabs.onFindResult.addListener(function(pageId, count, index) {
		var tabData = tabBar.getTabByData('pageId', pageId).data;
		var findbar = qqbrowser.layout.findbar;
		
		tabData.findInfo.content = findbar.getInputContent();
		tabData.findInfo.index = index;
		tabData.findInfo.count = count;
		findbar.setCurrentCount(index);
		findbar.setTotalCount(count);
		findbar.showFindCount(true);

	});

	/**
	 * 接收页面发送的WebCmd消息，解决农场闹钟死循环的问题
	 */
	qqbrowser.tabs.onCustomEvent.addListener(function(pageId, cmdName, data, windowId) {
		if (browser.window.currentId() !== windowId && cmdName !== "WebCmd") {
			return;
		}
		data = JSON.parse(data);
		// 处理云词典全局开关，因与前逻辑为完全独立的两部分，故在此定义该模块用到的变量	simonsliu 2011-11-09
		var cmdType = data[0], cmdParam = data[1];
		if (cmdType === "toggleCloudDict") {
			if (cmdParam === "isOpen") {
				qqbrowser.layout.cloudDictButton.open();
			} else {
				qqbrowser.layout.cloudDictButton.close();
			}
			// 处理云词典全局开关 END
			// 处理QQ农场
		} else {
			var request = null;
			if (qqbrowser.js.logic.farmAlarmRequest) {
				request = qqbrowser.js.logic.farmAlarmRequest;
			}
			if (data[0] == "1") {
				var str = data[1];
				var reg = /%20uin=o0[\d]+/g;

				var result = str.match(reg)[0].replace("%20uin=o0", "");
				if (result == request.alarmUin) {
					qqbrowser.js.logic.isFarmAlarmPopCallBack = false;
					qqbrowser.js.logic.farmAlarmCount--;
					return;
				} else {
					qqbrowser.js.logic.farmAlarmCount--;
				}
			} else if (data[0] === "0") {
				qqbrowser.js.logic.farmAlarmCount--;
			}

			if (qqbrowser.js.logic.farmAlarmCount === 0 && qqbrowser.js.logic.isFarmAlarmPopCallBack) {
				if (request.commandType === "alarmCom") {
					if (browser.window.currentId() !== request.currentId) {
						return;
					}
					var oParent = {};
					oParent.type = "window";
					// add by littleli 将每个闹钟的父容器设为传递过来的顶层窗口之上
					// 解决 bug 7268925:每次闹钟提醒tips都只弹在第一个窗口
					oParent.id = request.currentId;
					qqbrowser.dialog.create(oParent, "aero\\farmAlert.html", 340, 164, true, escape("农场小闹钟"), true, request);
					qqbrowser.tip.destroyMe();
					qqbrowser.extension.builtin.statistics.increase(STATIS_CMD_TOOLBAR_QZONE_QQFARM_POPUP_WINDOW_WHEN_ALARM);
				}
			}
		}
	});

	qqbrowser.tabs.onPageFind.addListener(function() {
		var viewManager = qqbrowser.js.logic.viewManager,
			findbar = qqbrowser.layout.findbar, tabData = tabBar.activeTab.data;

		// 如果为内部页面或空白页则不提供页面内查找功能
		if (rInnerPage.test(tabData.url) || tabData.url === BLANK_PAGE_URL) {
			return;
		}

		// 根据当前tab记录的信息
		if (tabData.findInfo === undefined) { // 第一次打开初始化状态
			tabData.findInfo = {};
			tabData.findInfo.isShow = true;
			findbar.show(true);
			findbar.setInputContent("");
			findbar.showFindCount(false);
			addressbar.blur();
			viewManager.setFocus2Skin(document.getElementById("qqbrowser-widgets-findbar-inputSpace"));
		} else {
			if (tabData.findInfo.isShow) {
				tabData.findInfo.isShow = false;
				// 记录当前的查找输入内容
				tabData.findInfo.currentKeyWord = findbar
					.getInputContent();
				findbar.show(false);
				browser.tabs.stopFinding(true);
				viewManager.setFocus2Web();
			} else {
				tabData.findInfo.isShow = true;
				// 恢复查找输入内容
				// findbar.setInputContent(tabData.findInfo.currentKeyWord);
				if (tabData.findInfo.count) { // 如果此时查找结果，那么显示
					findbar.showFindCount(true);
					findbar
						.setCurrentCount(tabData.findInfo.index);
					findbar
						.setTotalCount(tabData.findInfo.count);
				} else {
					findbar.showFindCount(false);
				}

				findbar.show(true);
				addressbar.blur();
				viewManager
					.setFocus2Skin($("#qqbrowser-widgets-findbar-inputSpace"));

				if (findbar.getInputContent() !== '') { // 如果当前查找栏内容不为空，那么将其全选
					setTimeout(function() {
						var findInput = document.getElementById('qqbrowser-widgets-findbar-inputSpace');
						findInput.select();
					}, 0);

				}

			}
		}
	});

	// 密码自动保存扩展发过来的消息
	qqbrowser.extension.onEvent.addListener(function(event, data) {
		data = JSON.parse(data);
		var savePWinfobar = qqbrowser.layout.savePWinfobar,
			tabData = tabBar.getTabByData('pageId', data.pageId).data;
		//data = eval('(' + data + ')');

		if (event == 'EventAutoFillTip') {
			var nickname = data.nickname;
			var title = data.title;
			var tempNickname = unescape(unescape(nickname));
			var tempTitle = unescape(unescape(title));

			savePWinfobar.show(true);
			browser.extension.builtin.statistics.increase(STATIS_TIPBAR_CODESAVE_POPED);
			tabData.savePW = [ tempNickname, tempTitle ];
			savePWinfobar.currentPageId = data.pageId;
		}
	}, {
		evtOwner: '{75A78384-8765-4852-ABB7-8D5FA8BF48E2}'
	});

	/**
	 * 解决开启彩贝功能之后，链接重定向的问题
	 */
	qqbrowser.tabs.onBeforeNavigate.addListener(function(pageId, url, isRedirect, srcUrl, visitLinkType, parentUrl) {
		var tab = tabBar.getTabByData('pageId', pageId), tabData = tab.data;

		// 彩贝相关的域名截取
		//var tempDomain = url.substring(url.indexOf("/") + 2);
		var domain = url;

		if (qqbrowser.js.logic.caibeiBindConfirm && qqbrowser.js.logic.isLogin && !tabData.navFlag) { // 开启特权后的重定向工作
			caibeiNav(domain, pageId);
		}

		function caibeiNav(domain, pageId) {
			var conf = qqbrowser.js.logic.caibeiInfo["conf"];
			var info = qqbrowser.js.logic.caibeiInfo["info"];

			if (conf[domain] !== undefined) {
				var id = conf[domain];
				var caibeiInfo = info[id];

				caibeiInfobar.url = unescape(caibeiInfo["login_url"]);
				tabData.caibeiUrl = caibeiInfobar.url;
			}
		}

		if (visitLinkType === 5 || visitLinkType === 10 || visitLinkType === 4) {
			return false;
		} else {
			if (typeof tabData.caibeiUrl === "undefined" || tabData.caibeiUrl === "") {
				return false;
			} else if (!tabData.navFlag) {
				tabData.navFlag = true;
				qqbrowser.page.navigate(pageId, tabData.caibeiUrl, 0);
				return true;
			}
			return false;
		}

	});
})(window);
